@extends('layouts.master')

@section('title')
    {{ __('manage') . ' ' . __('topic') }}
@endsection

@section('content')
    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">
                {{ __('manage') . ' ' . __('topic') }}
            </h3>
        </div>
        <div class="row">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">
                            {{ __('create') . ' ' . __('topic') }}
                        </h4>
                        <form class="pt-3 add-topic-form" id="create-form" data-success-function="formSuccessFunction" action="{{ route('lesson-topic.store') }}"
                              method="POST" novalidate="novalidate">
                            <div class="form-group">
                                <label>{{ __('Class Section') }} <span class="text-danger">*</span></label>
                                <select name="class_section_id" id="class-section-id" class="class_section_id form-control">
                                    <option value="">{{ __('Select Class Section') }}</option>
                                    @foreach ($class_section as $section)
                                        <option value="{{ $section->id }}" data-class="{{ $section->class->id }}">
                                            {{ $section->full_name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group">
                                <label>{{ __('subject') }} <span class="text-danger">*</span></label>
                                <select name="class_subject_id" id="subject-id" class="form-control">
                                    <option value="">-- {{ __('Select Subject') }} --</option>
                                    <option value="data-not-found">-- {{ __('no_data_found') }} --</option>
                                    @foreach ($subjectTeachers as $item)
                                        <option value="{{ $item->class_subject_id }}" data-class-section="{{ $item->class_section_id }}">{{ $item->subject_with_name}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group">
                                <label>{{ __('lesson') }} <span class="text-danger">*</span></label>
                                <select name="lesson_id" id="topic-lesson-id" class="form-control">
                                    <option value="">-- {{ __('lesson') }} --</option>
                                    <option value="data-not-found">-- {{ __('no_data_found') }} --</option>
                                    @foreach ($lessons as $item)
                                        <option value="{{ $item->id }}" data-class-section="{{ $item->class_section_id }}" data-subject="{{ $item->class_subject_id }}">{{ $item->name}}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group">
                                <label>{{ __('topic_name') }} <span class="text-danger">*</span></label>
                                <input type="text" id="name" name="name" placeholder="{{ __('topic_name') }}"
                                       class="form-control"/>
                            </div>

                            <div class="form-group">
                                <label>{{ __('topic_description') }} <span class="text-danger">*</span></label>
                                <textarea id="description" name="description" placeholder="{{ __('topic_description') }}" class="form-control"></textarea>
                            </div>

                            <hr>
                            <h4 class="mb-3">{{ __('files') }}</h4>

                            <div class="form-group files_data">
                                <div data-repeater-list="file_data">
                                    <div class="row file_type_div" id="file_type_div" data-repeater-item>
                                        <div class="form-group col-xl-2">
                                            <label>{{ __('type') }} </label>
                                            <select id="file_type" name="file[0][type]" class="form-control file_type">
                                                <option value="">--{{ __('select') }}--</option>
                                                <option value="file_upload">{{ __('file_upload') }}</option>
                                                <option value="youtube_link">{{ __('youtube_link') }}</option>
                                                <option value="video_upload">{{ __('video_upload') }}</option>
                                            </select>
                                        </div>
                                        <div class="form-group col-xl-3" id="file_name_div" style="display: none">
                                            <label>{{ __('file_name') }} <span class="text-danger">*</span></label>
                                            <input type="text" name="file[0][name]" class="file_name form-control" placeholder="{{ __('file_name') }}" required>
                                        </div>
                                        <div class="form-group col-xl-3" id="file_thumbnail_div" style="display: none">
                                            <label>{{ __('thumbnail') }} <span class="text-danger">*</span></label>
                                            <input type="file" name="file[0][thumbnail]" class="file_thumbnail form-control" required>
                                        </div>
                                        <div class="form-group col-xl-3" id="file_div" style="display: none">
                                            <label>{{ __('file_upload') }} <span class="text-danger">*</span></label>
                                            <input type="file" name="file[0][file]" class="file form-control" placeholder="" required>
                                        </div>
                                        <div class="form-group col-xl-3" id="file_link_div" style="display: none">
                                            <label>{{ __('link') }} <span class="text-danger">*</span></label>
                                            <input type="text" name="file[0][link]" class="file_link form-control" placeholder="{{ __('link') }}" required>
                                        </div>

                                        <div class="form-group col-xl-1 mt-4">
                                            <button type="button" class="btn btn-inverse-danger btn-icon remove-lesson-topic-fileremove-lesson-topic-file" data-repeater-delete>
                                                <i class="fa fa-times"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group mt-4">
                                    <button type="button" class="btn btn-inverse-success add-lesson-topic-file" data-repeater-create>
                                        <i class="fa fa-plus"></i> {{__('add_new_files')}}
                                    </button>
                                </div>
                            </div>
                            <input class="btn btn-theme" id="create-btn" type="submit" value={{ __('submit') }}>
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-md-12 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">
                            {{ __('list') . ' ' . __('topic') }}
                        </h4>
                        <div id="toolbar">
                            <div class="row">
                                <div class="col">
                                    <label for="filter-class-section-id" class="filter-menu">{{__("Class Section")}}</label>
                                    <select name="filter-class-section-id" id="filter-class-section-id" class="form-control">
                                        <option value="">{{ __('all') }}</option>
                                        @foreach ($class_section as $class)
                                            <option value="{{ $class->id }}">
                                                {{ $class->full_name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col">
                                    <label for="filter-class-subject-id" class="filter-menu">{{__("Subject")}}</label>
                                    <select name="filter-class-subject-id" id="filter-subject-id" class="form-control">
                                        <option value="" data-all="true">{{ __('all') }}</option>
                                        <option value="data-not-found" style="display: none">-- {{ __('no_data_found') }} --</option>
                                        @foreach ($subjectTeachers as $item)
                                            <option value="{{ $item->class_subject_id }}" data-class-section="{{ $item->class_section_id }}">{{ $item->subject_with_name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col">
                                    <label for="filter_lesson_id" class="filter-menu">{{__("Lessons")}}</label>
                                    <select name="filter_lesson_id" id="filter_lesson_id" class="form-control">
                                        <option value="">{{ __('all') }}</option>
                                        @foreach ($lessons as $lesson)
                                            <option value="{{ $lesson->id }}">
                                                {{ $lesson->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                        </div>
                        <table aria-describedby="mydesc" class='table table-striped' id='table_list' data-toggle="table"
                               data-url="{{ route('lesson-topic.show', 1) }}" data-click-to-select="true"
                               data-side-pagination="server" data-pagination="true"
                               data-page-list="[5, 10, 20, 50, 100, 200]" data-search="true" data-toolbar="#toolbar"
                               data-show-columns="true" data-show-refresh="true" data-trim-on-search="false"
                               data-mobile-responsive="true" data-sort-name="id" data-sort-order="desc"
                               data-maintain-selected="true" data-export-types='["txt","excel"]'
                               data-query-params="CreateTopicQueryParams"
                               data-export-options='{ "fileName": "topic-list-<?= date('d-m-y') ?>" ,"ignoreColumn": ["operate"]}'
                               data-show-export="true">
                            <thead>
                            <tr>
                                <th scope="col" data-field="id" data-sortable="true" data-visible="false"> {{ __('id') }}</th>
                                <th scope="col" data-field="no">{{ __('no.') }}</th>
                                <th scope="col" data-field="name" data-sortable="true">{{ __('name') }}</th>
                                <th scope="col" data-field="description" data-sortable="true"> {{ __('description') }}</th>
                                <th scope="col" data-field="lesson.class_section.full_name" data-sortable="true"> {{ __('class_section') }}</th>
                                <th scope="col" data-field="lesson.subject.name_with_type" data-sortable="true"> {{ __('subject') }}</th>
                                <th scope="col" data-field="lesson.name" data-sortable="true"> {{ __('lesson') }}</th>
                                <th scope="col" data-field="file" data-formatter="fileFormatter" data-sortable="true">{{ __('file') }}</th>
                                <th scope="col" data-field="created_at" data-sortable="true" data-visible="false"> {{ __('created_at') }}</th>
                                <th scope="col" data-field="updated_at" data-sortable="true" data-visible="false"> {{ __('updated_at') }}</th>
                                <th scope="col" data-events="lessonTopicEvents" data-field="operate">{{ __('action') }}</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script>
        function formSuccessFunction(response) {
            setTimeout(() => {
                window.location.reload()
            }, 1000);
        }
    </script>
@endsection
