<?php $__env->startSection('title'); ?>
    <?php echo e(__('plans')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<style>
    :root {
    --primary-color: <?php echo e($settings['theme_primary_color'] ?? '#56cc99'); ?>;
    --secondary-color: <?php echo e($settings['theme_secondary_color'] ?? '#215679'); ?>;
   
}
</style>
    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">
                <?php echo e(__('manage') . ' ' . __('subscription')); ?>

            </h3>
        </div>
        <div class="row">
            <div class="col-md-12 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <?php if($upcoming_package): ?>
                            <h3 class="card-title text-danger"><?php echo e(__('note')); ?> : <?php echo e(__('if_youve_already_made_payment_for_your_upcoming_plan_changes_or_updates_to_the_current_and_upcoming_plan_will_not_be_permitted')); ?></h3>
                        <?php endif; ?>
                        
                        <div class="row pricing-table mt-4">
                            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-6 col-xl-4 grid-margin stretch-card pricing-card">
                                    <div class="card <?php if($package->highlight): ?> border-success ribbon <?php else: ?> border-primary <?php endif; ?>  border pricing-card-body">
                                        <?php if($package->is_trial != 1): ?>
                                            <?php if($package->type == 1): ?>
                                                <span class="package-type-badge postpaid-color"><?php echo e(__('postpaid')); ?></span>
                                            <?php else: ?>
                                                <span class="package-type-badge prepaid-color"><?php echo e(__('prepaid')); ?></span>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        
                                        <div class="text-center pricing-card-head mb-2">
                                            <h3><?php echo e(__($package->name)); ?></h3>
                                            <p><?php echo e($package->description); ?></p>
                                            <h1 class="font-weight-normal mb-2"></h1>
                                            <hr>
                                            <div class="row">
                                                <?php if($package->is_trial == 1): ?>
                                                    <div class="col-sm-12 col-md-12">
                                                        <b><?php echo e(__('package_information')); ?></b>
                                                    </div>
                                                    <div class="col-sm-12 col-md-12 mt-3 text-small">
                                                        <?php echo e(__('student_limit')); ?> : <?php echo e($settings['student_limit']); ?>

                                                    </div>

                                                    <div class="col-sm-12 col-md-12 mt-1 text-small">
                                                        <?php echo e(__('staff_limit')); ?> : <?php echo e($settings['staff_limit']); ?>

                                                    </div>
                                                    <div class="col-sm-12 col-md-12 mt-1 text-small">
                                                        <?php echo e($settings['trial_days']); ?> / <?php echo e(__('days')); ?>

                                                    </div>
                                                <?php elseif($package->type == 0): ?>
                                                    <div class="col-sm-12 col-md-12">
                                                        <b><?php echo e(__('package_price_information')); ?></b>
                                                        <hr>
                                                    </div>
                                                    <div class="col-sm-12 col-md-12">
                                                        <h3> <?php echo e($settings['currency_symbol']); ?> <?php echo e($package->charges); ?></h3>
                                                    </div>
                                                    <div class="col-sm-12 col-md-12 mt-3 text-small">
                                                        <?php echo e(__('student_limit')); ?> : <?php echo e($package->no_of_students); ?> / <?php echo e(__('staff_limit')); ?> : <?php echo e($package->no_of_staffs); ?>

                                                    </div>
                                                    <div class="col-sm-12 col-md-12 mt-2 text-small">
                                                        <?php echo e($package->days); ?> / <?php echo e(__('days')); ?>

                                                    </div>
                                                <?php else: ?>
                                                    <div class="col-sm-12 col-md-12">
                                                        <b><?php echo e(__('package_price_information')); ?></b>
                                                        <hr>
                                                    </div>
                                                    <div class="col-sm-12 col-md-12 mt-3 text-small">
                                                        <h5>
                                                            <?php echo e(__('per_student_charges')); ?> : <?php echo e($settings['currency_symbol']); ?> <?php echo e($package->student_charge); ?> / <?php echo e(__('per_staff_charges')); ?> : <?php echo e($settings['currency_symbol']); ?> <?php echo e($package->staff_charge); ?>

                                                        </h5>
                                                    </div>

                                                    <div class="col-sm-12 col-md-12 mt-1 text-small">
                                                        <?php echo e($package->days); ?> / <?php echo e(__('days')); ?>

                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <hr>

                                        <ul class="list-unstyled">
                                            <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if(in_array($feature->id, $package->package_feature->pluck('feature_id')->toArray())): ?>
                                                    <li><i class="fa fa-check check mr-2"></i><?php echo e(__($feature->name)); ?></li>
                                                <?php else: ?>
                                                    <li><i class="fa fa-times no-feature mr-2"></i><span
                                                            class="text-decoration-line-through"><?php echo e(__($feature->name)); ?></span>
                                                    </li>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                        <?php if(!$upcoming_package): ?>
                                            <?php if($current_plan): ?>
                                                <?php if($package->id == $current_plan->package_id): ?>
                                                    <div class="wrapper mb-3">
                                                        <a href="#" class="btn disabled <?php if($package->highlight): ?> btn-success <?php else: ?> btn-outline-primary <?php endif; ?> btn-block select-plan" data-type="<?php echo e($package->type); ?>" data-id="<?php echo e($package->id); ?>"><?php echo e(__('current_active_plan')); ?></a>
                                                    </div>

                                                    
                                                    <div class="col-sm-12 col-md-12">
                                                        <a href="#" class="btn disabled <?php if($package->highlight): ?> btn-outline-success <?php else: ?> btn-outline-primary <?php endif; ?> btn-block select-plan" data-type="<?php echo e($package->type); ?>" data-id="<?php echo e($package->id); ?>"><?php echo e(__('update_upcoming_plan')); ?></a>
                                                    </div>
                                                <?php else: ?>
                                                    <div class="row">
                                                        <div class="col-sm-12 col-md-12 mb-3">
                                                            
                                                            <?php if($paymentConfiguration && $package->type == 0): ?>
                                                                <form action="<?php echo e(url('subscriptions/razorpay')); ?>" class="razorpay-form-<?php echo e($package->id); ?>" method="POST"> <?php echo csrf_field(); ?>
                                                                    <input type="hidden" name="package_id" class="package_id_<?php echo e($package->id); ?>" value="<?php echo e($package->id); ?>">
                                                                    <input type="hidden" name="amount" class="bill_amount_<?php echo e($package->id); ?>" value="<?php echo e($package->charges); ?>">
        
                                                                    <input type="hidden" name="type" class="type_<?php echo e($package->id); ?>" value="package">
                                                                    <input type="hidden" name="package_type" class="package_type_<?php echo e($package->id); ?>" value="immediate">
        
                                                                    <input type="hidden" name="razorpay_payment_id" class="razorpay_payment_id" value="">
                                                                    <input type="hidden" name="razorpay_signature" class="razorpay_signature" value="">
                                                                    <input type="hidden" name="razorpay_order_id" class="razorpay_order_id" value="">
        
                                                                    <input type="hidden" name="paymentTransactionId" class="paymentTransactionId" value="">
        
                                                                    <button class="btn btn-theme w-100" id="razorpay-button-<?php echo e($package->id); ?>"><?php echo e(__('update_current_plan')); ?></button>
                                                                </form>
                                                            <?php else: ?>
                                                                <a href="#" class="btn start-immediate-plan <?php if($package->highlight): ?> btn-success <?php else: ?> btn-primary <?php endif; ?> btn-block" data-type="<?php echo e($package->type); ?>" data-id="<?php echo e($package->id); ?>"><?php echo e(__('update_current_plan')); ?></a>
                                                            <?php endif; ?>                                                   
                                                        </div>

                                                        
                                                        <div class="col-sm-12 col-md-12">
                                                            <a href="#" class="btn <?php if($package->highlight): ?> btn-outline-success <?php else: ?> btn-outline-primary <?php endif; ?> btn-block select-plan" data-type="<?php echo e($package->type); ?>" data-id="<?php echo e($package->id); ?>" data-iscurrentplan="0"><?php echo e(__('update_upcoming_plan')); ?></a>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <?php if($paymentConfiguration && $package->type == 0): ?>
                                                    
                                                    <div class="wrapper">
                                                        <form action="<?php echo e(url('subscriptions/razorpay')); ?>" class="razorpay-form-<?php echo e($package->id); ?>" method="POST">
                                                            <?php echo csrf_field(); ?>
                                                            <input type="hidden" name="package_id" class="package_id_<?php echo e($package->id); ?>" value="<?php echo e($package->id); ?>">
                                                            <input type="hidden" name="amount" class="bill_amount_<?php echo e($package->id); ?>" value="<?php echo e($package->charges); ?>">

                                                            <input type="hidden" name="type" class="type_<?php echo e($package->id); ?>" value="package">
                                                            <input type="hidden" name="package_type" class="package_type_<?php echo e($package->id); ?>" value="new">

                                                            <input type="hidden" name="razorpay_payment_id" class="razorpay_payment_id" value="">
                                                            <input type="hidden" name="razorpay_signature" class="razorpay_signature" value="">
                                                            <input type="hidden" name="razorpay_order_id" class="razorpay_order_id" value="">

                                                            <input type="hidden" name="paymentTransactionId" class="paymentTransactionId" value="">

                                                            <button class="btn btn-theme w-100" id="razorpay-button-<?php echo e($package->id); ?>"><?php echo e(__('get_start')); ?></button>
                                                        </form>
                                                    </div>
                                                <?php else: ?>
                                                    <div class="wrapper">
                                                        <a href="#" class="btn <?php if($package->highlight): ?> btn-success <?php else: ?> btn-outline-primary <?php endif; ?> btn-block select-plan" data-type="<?php echo e($package->type); ?>" data-iscurrentplan="1" data-id="<?php echo e($package->id); ?>"><?php echo e(__('get_start')); ?></a>
                                                    </div>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        // razorpay-payment-button
    setTimeout(() => {
        $('.razorpay-payment-button').addClass('btn btn-info w-100');
    }, 100);
    </script>


<script src="https://checkout.razorpay.com/v1/checkout.js"></script>

<?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<script>
    document.addEventListener("DOMContentLoaded", function() {
        // Add the event listener for the button to initiate the payment

        setTimeout(() => {
            document.getElementById('razorpay-button-<?php echo e($package->id); ?>').onclick = function(e) {
                let baseUrl = window.location.origin;
                var order_id = '';
                var paymentTransactionId = '';

                $.ajax({
                    type: "post",
                    url: baseUrl + '/subscriptions/create/order-id',
                    data: {
                        amount : $('.bill_amount_<?php echo e($package->id); ?>').val(),
                        currency : "<?php echo e($system_settings['currency_code'] ?? 'INR'); ?>",

                        type : $('.type_<?php echo e($package->id); ?>').val(),
                        package_type : $('.package_type_<?php echo e($package->id); ?>').val(),
                        package_id : $('.package_id_<?php echo e($package->id); ?>').val(),
                        upcoming_plan_type : $('.upcoming_plan_type').val(),
                        subscription_id : $('.subscription_id').val(),
                        feature_id : $('.feature_id').val(),
                        end_date : $('.end_date').val(),
                        
                    },
                    success: function (response) {
                        if (response.data) {
                            order_id = response.data.order.id;
                            paymentTransactionId = response.data.paymentTransaction.id;
                            var options = {
                                "key": "<?php echo e($paymentConfiguration->api_key ?? ''); ?>", // Enter the Key ID generated from the Dashboard
                                "amount": $('.bill_amount').val() * 100, // Amount is in currency subunits. Default currency is INR. Hence, 100 refers to 1 INR
                                "currency": "<?php echo e($system_settings['currency_code'] ?? 'INR'); ?>",
                                "name": "<?php echo e($system_settings['system_name'] ?? 'eSchool-Saas'); ?>",
                                "description": "Razorpay",
                                "order_id": order_id,
                                "handler": function(response) {
                                    // Set the response data in the form
                                    $('.razorpay_payment_id').val(response.razorpay_payment_id);
                                    $('.razorpay_signature').val(response.razorpay_signature);
                                    $('.razorpay_order_id').val(response.razorpay_order_id);
                                    $('.paymentTransactionId').val(paymentTransactionId);

                                    // Submit the form
                                    document.querySelector('.razorpay-form-<?php echo e($package->id); ?>').submit();
                                }
                            };

                            var rzp1 = new Razorpay(options);
                            rzp1.open();
                        } else {
                            Swal.fire({icon: 'error', text: response.message});
                        }
                    }
                });
                e.preventDefault();
            }
        }, 100); 
        
    });
</script> 
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\_KUILINGA\CustomerProject\SchoolManag\web\resources\views/subscription/index.blade.php ENDPATH**/ ?>